//////////
//
//	File:		ComApplication.h
//
//	Contains:	Functions that could be overridden in a specific application.
//
//	Written by:	Tim Monroe
//				Based (heavily!) on the MovieShell code written by Apple DTS
//
//	Copyright:	 1994-1997 by Apple Computer, Inc., all rights reserved.
//
//	Change History (most recent first):
//
//	   <4>	 	09/11/97	rtm		merged MacApplication.h and WinApplication.h
//	   <3>	 	08/21/97	rtm		begun adding Windows support
//	   <2>	 	11/27/96	rtm		conversion to personal coding style
//	   <1>	 	12/21/94	khs		first file
//	   
//////////

#pragma once

//////////
// header files
//////////

#ifndef __QUICKTIMEVR__
#include <QuickTimeVR.h>
#endif

#ifndef __QTUtilities__
#include "QTUtilities.h"
#endif

#include <TextUtils.h>
#include <string.h>

#if TARGET_OS_MAC
#include "MacFramework.h"
#include "AppConfiguration.h"
#endif	// TARGET_OS_MAC

#if TARGET_OS_WIN32
#include "WinFramework.h"
#endif	// TARGET_OS_WIN32

#include "ComResource.h"

//////////
// constants
//////////

#define kTextDialogID			131
#define kTextOKIndex			1
#define kTextLabelIndex			2
#define kTextTextEditIndex		3

#define kEditDialogID			132
#define kEditOKIndex			1
#define kEditLabelIndex			2
#define kEditTextEditIndex		3
#define kEditCancelIndex		4

//////////
// structures
//////////

// application-specific data
typedef struct {
	Boolean						fMovieHasText;		// does the movie have a text track?
	Boolean						fTextIsChapter;		// is the text track also a chapter track?
	Track						fTextTrack;			// the (first) text track in the movie
	MediaHandler				fTextHandler;		// the media handler for the text track
} ApplicationDataRecord, *ApplicationDataPtr, **ApplicationDataHdl;


// the function prototypes are in the file MacFramework.h or WinFramework.h